var	 ajax_kabupaten_url = '';
var  ajax_user_provider_url = '';

var setKabupatenAjaxURL = function(path){
	ajax_kabupaten_url = path;
}

var setUserProviderAjaxURL = function(path){
	ajax_user_provider_url = path;
}

/*INIT FB*/
window.fbAsyncInit = function() {
    FB.init({
        appId      : '504391623265721',
        cookie     : true,  // enable cookies to allow the server to access the session
        xfbml      : true,  // parse social plugins on this page
        version    : 'v2.11' // use graph api version 2.8
    });
};

// Load the SDK asynchronously
(function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = "https://connect.facebook.net/en_US/sdk.js";
    fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));
/*INIT FB*/

function fb_sync(){
    FB.login(function(response){
        console.log('statusChangeCallback');
        console.log(response);
        if (response.status === 'connected') {
			$.ajax({
				url : ajax_user_provider_url,
				dataType : 'json',
				type : 'post',
				data : {
					provider:"facebook",
					provider_id:response.authResponse.userID,
					provider_token:response.authResponse.accessToken
				},
				success : function(resp){
					if (resp.success){
						window.location.href = '';
						show_message('success', resp.message, '');
					}else{
						show_message('danger', resp.message, '');
					}
				},
				error : function (xhr, status, error){
					show_message('danger', error, '');
				}
			})
        } else {
        	show_message('danger', 'Tidak dapat terhubung dengan Facebook, mohon dicoba kembali.', '');
        }            
    },
        {scope:'public_profile,email'}
    )
}


/*INIT GOOGLE*/
gapi.load('auth2', function(){
	// Retrieve the singleton for the GoogleAuth library and set up the client.
	auth2 = gapi.auth2.init({
		client_id: '42655519165-b4dgg33bnbql21gfij2jiepgad6nph6m.apps.googleusercontent.com',
		cookiepolicy: 'single_host_origin',
	});
	attachSignin(document.getElementById('google_sync'));
});

function attachSignin(element) {
	auth2.attachClickHandler(element, {},
		function(googleUser) {
			google_sync(googleUser);
		}, function(error) {
			show_message('danger', 'Tidak dapat terhubung dengan Google, mohon dicoba kembali.', '');
		}
	);
}
/*INIT GOOGLE*/

function google_sync(googleUser){
	var profile = googleUser.getBasicProfile();
	var id_token = googleUser.getAuthResponse().id_token;
	var	email = profile.getEmail();
	
	$.ajax({
		url : ajax_user_provider_url,
		dataType : 'json',
		type : 'post',
		data : {
			provider:"google",
			provider_id:email,
			provider_token:id_token
		},
		success : function(resp){
			if (resp.success){
				window.location.href = '';
				show_message('success', resp.message, '');
			}else{
				show_message('danger', resp.message, '');
			}
		},
		error : function (xhr, status, error){
			show_message('danger', error, '');
		}
	})

}


$(window).ready(function(e){



	$('select[name="user_aprov_id"]').bind('change',function(e){
		$("select[name=user_akab_id]").empty();
		$("select[name=user_akab_id]").hide();
		var user_aprov_id = $(this).val();
		if(user_aprov_id==''){
			return false;
		}else{
			$.ajax({
				url : ajax_kabupaten_url,
				dataType : 'json',
				type : 'post',
				data : {user_aprov_id:user_aprov_id},
				success : function(resp){
					if (resp.success){
						$("select[name=user_akab_id]").append(resp.message);
						$("select[name=user_akab_id]").show();
					}else{
						show_message('danger', resp.message, '');
					}
				},
				error : function (xhr, status, error){
					show_message('danger', error, '');
				}
			})
		}		 	
	});


	$("#profile_form").bind('submit',function(e){
		e.preventDefault();
		var	user_photo = $("input[name=user_photo]").prop("files")[0];

		var form_data = new FormData( $("#profile_form")[0] );
		form_data.append('user_photo',user_photo);

		$.ajax({		
			url : $("#profile_form").attr('action'),
			type : $("#profile_form").attr('method'),
			contentType : false,
			processData : false,
			dataType : 'json',
			data : form_data,
			success : function(resp){
				if (resp.success){
					window.location.href = '';
					show_message('success', resp.message, '');
				}else{
					show_message('danger', resp.message, '');
				}
			},
            error : function (xhr, status, error){
		        show_message('danger', error, '');
            }
		})
	})	

	$("#password_form").bind('submit',function(e){
		e.preventDefault();
		$.ajax({		
			url : $("#password_form").attr('action'),
			type : $("#password_form").attr('method'),
			dataType : 'json',
			data : $("#password_form").serialize(),
			success : function(resp){
				if (resp.success){
					window.location.href = '';
					show_message('success', resp.message, '');
				}else{
					show_message('danger', resp.message, '');
				}
			},
            error : function (xhr, status, error){
		        show_message('danger', error, '');
            }
		})
	})	

	$('select[name="project_filter"]').bind('change',function(e){
		var project_filter = $(this).val();
		if(project_filter==''){
			$(".project_user_data").show();
		}else{
			$(".project_user_data").hide();
			$(".project_"+project_filter).show();
		}		 	
	});

	$("#send_mail_form").bind('submit',function(e){
		e.preventDefault();
		$.ajax({		
			url : $("#send_mail_form").attr('action'),
			type : $("#send_mail_form").attr('method'),
			dataType : 'json',
			data : $("#send_mail_form").serialize(),
			success : function(resp){
				if (resp.success){
					show_message('success', resp.message, '');
					$("#send_mail_form")[0].reset();
				}else{
					show_message('danger', resp.message, '');
				}
			},
            error : function (xhr, status, error){
		        show_message('danger', error, '');
            }
		})
	})	

	$("#kta_request_form").bind('submit',function(e){
		e.preventDefault();
		$.ajax({		
			url : $("#kta_request_form").attr('action'),
			type : $("#kta_request_form").attr('method'),
			dataType : 'json',
			data : $("#kta_request_form").serialize(),
			success : function(resp){
				if (resp.success){
					window.location.href = '';
					//show_message('success', resp.message, '');
				}else{
					show_message('danger', resp.message, '');
				}
			},
            error : function (xhr, status, error){
		        show_message('danger', error, '');
            }
		})
	})	

})