function isNumber(n) {
	return !isNaN(parseFloat(n)) && isFinite(n) ;
}

function price_format(price){
	return accounting.formatMoney(price,[symbol = ""],[precision = 0],[thousand = "."],[decimal = ","],[format = "%s%v"]);
}		

function show_message(type, message,icon){
    Metronic.alert({
        container: '#bootstrap_alerts', // alerts parent container(by default placed after the page breadcrumbs)
        type: type,  // alert's type
        message: message,  // alert's message
        close : '0',
        reset: '1', // close all previouse alerts first
        focus: '1', // auto scroll to the alert after shown
        icon: icon // put icon before the message
    });				
}	



function show_widget_message(type, message,icon){
    Metronic.alert({
        container: '.bootstrap_widget_alerts', // alerts parent container(by default placed after the page breadcrumbs)
        type: type,  // alert's type
        message: message,  // alert's message
        close : '0',
        reset: '1', // close all previouse alerts first
        focus: '1', // auto scroll to the alert after shown
        icon: icon // put icon before the message
    });				
}	

$('.date-picker').datepicker({
    rtl: Metronic.isRTL(),
    format: 'yyyy-mm-dd',
    orientation: "left",
    autoclose: true
});

$(".date-picker").each(function(e){
	var current = $(this).attr('current');
	if (current!=undefined){
		$(this).val(current);
	}
	//$(this).val($(this).attr('current'));
})	

    

function number_format(number, decimals, dec_point, thousands_sep) {
	number = (number + '').replace(/[^0-9+\-Ee.]/g, '');
	var n = !isFinite(+number) ? 0 : +number,
		prec = !isFinite(+decimals) ? 0 : Math.abs(decimals), sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
		dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
		s = '',
		toFixedFix = function (n, prec) {
			var k = Math.pow(10, prec); return '' + Math.round(n * k) / k;
		};
	// Fix for IE parseFloat(0.55).toFixed(0) = 0;
	s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
	if (s[0].length > 3) {
		s[0] = s[0].replace(/\B(?=(?:\d{3})+(?!\d))/g, sep);
	}
	if ((s[1] || '').length < prec) {
		s[1] = s[1] || '';
		s[1] += new Array(prec - s[1].length + 1).join('0'); }
	return s.join(dec);
}


var keyStr = "ABCDEFGHIJKLMNOP" +
           "QRSTUVWXYZabcdef" +
           "ghijklmnopqrstuv" +
           "wxyz0123456789+/" +
           "=";

function encode64(input) {
	input = escape(input);
	var output = "";
	var chr1, chr2, chr3 = "";
	var enc1, enc2, enc3, enc4 = "";
	var i = 0;

	do {
		chr1 = input.charCodeAt(i++);
		chr2 = input.charCodeAt(i++);
		chr3 = input.charCodeAt(i++);

		enc1 = chr1 >> 2;
		enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
		enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
		enc4 = chr3 & 63;

		if (isNaN(chr2)) {
			enc3 = enc4 = 64;
		} else if (isNaN(chr3)) {
			enc4 = 64;
		}

		output = output +
		keyStr.charAt(enc1) +
		keyStr.charAt(enc2) +
		keyStr.charAt(enc3) +
		keyStr.charAt(enc4);
		chr1 = chr2 = chr3 = "";
		enc1 = enc2 = enc3 = enc4 = "";
	} while (i < input.length);

	return output;
}

function decode64(input) {
	var output = "";
	var chr1, chr2, chr3 = "";
	var enc1, enc2, enc3, enc4 = "";
	var i = 0;

	// remove all characters that are not A-Z, a-z, 0-9, +, /, or =
	var base64test = /[^A-Za-z0-9\+\/\=]/g;
	if (base64test.exec(input)) {
		alert("There were invalid base64 characters in the input text.\n" +
		"Valid base64 characters are A-Z, a-z, 0-9, '+', '/',and '='\n" +
		"Expect errors in decoding.");
	}
	input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

	do {
		enc1 = keyStr.indexOf(input.charAt(i++));
		enc2 = keyStr.indexOf(input.charAt(i++));
		enc3 = keyStr.indexOf(input.charAt(i++));
		enc4 = keyStr.indexOf(input.charAt(i++));

		chr1 = (enc1 << 2) | (enc2 >> 4);
		chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
		chr3 = ((enc3 & 3) << 6) | enc4;

		output = output + String.fromCharCode(chr1);

		if (enc3 != 64) {
			output = output + String.fromCharCode(chr2);
		}
		if (enc4 != 64) {
			output = output + String.fromCharCode(chr3);
		}

		chr1 = chr2 = chr3 = "";
		enc1 = enc2 = enc3 = enc4 = "";

	} while (i < input.length);

	return unescape(output);
}

$(document).ready(function(e){

    $.ajaxSetup({
        beforeSend: function() {
           	//$("#modal-overlay").show();
           	Metronic.blockUI({
           		zIndex: 20000
           	});
        },
        complete: function() {
           // $("#modal-overlay").hide();
           Metronic.unblockUI();
        }
    });		
})

