<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Judul halaman akan diisi oleh view spesifik -->
    <title><?= $this->renderSection('pageTitle') ?> | <?= getenv('app.name') ?></title>
    <link rel="icon" type="image/png" href="<?= base_url('assets/favicon.ico') ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-gray-100 text-gray-800">

    <!-- Komponen Header -->
    <?= $this->include('frontend/components/_header') ?>

    <main class="container mx-auto px-4 py-8">
        <!-- Komponen Notifikasi -->
        <?= $this->include('frontend/components/_notifications') ?>

        <!-- Konten utama halaman -->
        <?= $this->renderSection('mainContent') ?>
    </main>
    
    <!-- Komponen Footer (jika ada) -->
    <?= $this->include('frontend/components/_footer') ?>

    <!-- Script spesifik halaman (jika ada) -->
    <?= $this->renderSection('pageScripts') ?>
</body>
</html>