<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= lang('Errors.pageNotFoundTitle') ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Kita perlu memuat Tailwind CSS di sini karena halaman ini tidak menggunakan layout utama -->
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700;900&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="flex items-center justify-center min-h-screen">
        <div class="text-center p-8">
            <h1 class="text-9xl font-black text-indigo-400">404</h1>
            <h2 class="text-4xl font-bold text-gray-800 mt-4"><?= lang('Errors.pageNotFound') ?></h2>
            <p class="text-gray-600 mt-4 mb-8 text-lg">
                <?= lang('Errors.pageNotFoundDesc') ?>
            </p>
            <a href="<?= site_url('/') ?>" 
               class="inline-block bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-lg shadow-lg transition-transform transform hover:scale-105">
                <?= lang('Errors.backToHomepage') ?>
            </a>
        </div>
    </div>
</body>
</html>