<?= $this->extend('backend/layouts/main') ?>

<?= $this->section('main') ?>

<!-- Form Filter -->
<div class="bg-white p-6 rounded-lg shadow-md mb-8">
    <h4 class="text-xl font-semibold mb-4"><?= lang('Admin/Transactions.filter') ?></h4>
    <!-- Ganti class grid untuk layout yang lebih baik -->
    <form action="<?= current_url() ?>" method="get" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
        
        <div>
            <label for="user_name" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterUser') ?></label>
            <!-- Terapkan class dari form frontend -->
            <input type="text" name="user_name" id="user_name" value="<?= esc($filters['user_name'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>

        <div>
            <label for="invoice_number" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterInvoice') ?></label>
            <input type="text" name="invoice_number" id="invoice_number" value="<?= esc($filters['invoice_number'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>

        <div>
            <label for="event_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterEvent') ?></label>
            <select name="event_id" id="event_id" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                <option value="">All Events</option>
                <?php foreach ($events as $event): ?>
                    <option value="<?= $event->id ?>" <?= (($filters['event_id'] ?? '') == $event->id) ? 'selected' : '' ?>><?= esc($event->name) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="church_id" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterChurch') ?></label>
            <select name="church_id" id="church_id" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                <option value="">All Churches</option>
                <?php foreach ($churches as $church): ?>
                    <option value="<?= $church->id ?>" <?= (($filters['church_id'] ?? '') == $church->id) ? 'selected' : '' ?>><?= esc($church->name) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="payment_status" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterPaymentStatus') ?></label>
            <select name="payment_status" id="payment_status" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                <option value="">All Statuses</option>
                <?php foreach ($payment_status as $status): ?>
                    <option value="<?= esc($status) ?>" <?= (($filters['payment_status'] ?? '') == $status) ? 'selected' : '' ?>><?= esc(ucfirst($status)) ?></option>
                <?php endforeach; ?>
            </select>
        </div>

        <div>
            <label for="payment_method" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterPaymentMethod') ?></label>
            <select name="payment_method" id="payment_method" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
                <option value="">All Payment Methods</option>
                <?php foreach ($payment_method as $method): ?>
                    <option value="<?= esc($method) ?>" <?= (($filters['payment_method'] ?? '') == $method) ? 'selected' : '' ?>><?= esc(ucfirst($method)) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div>
            <label for="start_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterStartDate') ?></label>
            <input type="date" name="start_date" id="start_date" value="<?= esc($filters['start_date'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>
        
        <div>
            <label for="end_date" class="block mb-2 text-sm font-medium text-gray-900"><?= lang('Admin/Transactions.filterEndDate') ?></label>
            <input type="date" name="end_date" id="end_date" value="<?= esc($filters['end_date'] ?? '') ?>" class="bg-gray-50 border border-gray-300 text-gray-900 sm:text-sm rounded-lg focus:ring-indigo-600 focus:border-indigo-600 block w-full p-2.5">
        </div>

        <!-- Perbaiki layout tombol -->
        <div class="col-span-1 sm:col-span-2 lg:col-span-3 flex items-end gap-4">
            <button type="submit" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 shadow-sm"><?= lang('Admin/Transactions.btnFilter') ?></button>
            <a href="<?= site_url('backend/transactions') ?>" class="bg-gray-200 text-gray-800 px-4 py-2 rounded-lg hover:bg-gray-300 shadow-sm"><?= lang('Admin/Transactions.btnReset') ?></a>
        </div>
    </form>
</div>


<!-- Tabel Data Transaksi (Styling ditambahkan) -->
<div class="overflow-x-auto bg-white rounded-lg shadow-md">
    <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colInvoice') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colDate') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colEvent') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colUser') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colTotal') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colPaymentMethod') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colStatus') ?></th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider"><?= lang('Admin/Transactions.colActions') ?></th>
            </tr>
        </thead>
        <tbody class="bg-white divide-y divide-gray-200">
            <?php if (!empty($transactions)): ?>
                <?php foreach ($transactions as $transaction): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?= esc($transaction->invoice_number) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= date('d M Y, H:i', strtotime($transaction->created_at)) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($transaction->event_name) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($transaction->user_name) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">Rp <?= number_format($transaction->total_amount, 0, ',', '.') ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?= esc($transaction->payment_type) ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full 
                            <?= $transaction->payment_status === 'paid' ? 'bg-green-100 text-green-800' : ($transaction->payment_status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800') ?>">
                            <?= esc(ucfirst($transaction->payment_status)) ?>
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="<?= route_to('admin.transactions.show', $transaction->uuid) ?>" class="text-indigo-600 hover:text-indigo-900"><?= lang('Admin/Transactions.viewDetails') ?></a>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" class="px-6 py-4 text-center text-gray-500"><?= lang('Admin/Transactions.noResults') ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Paginasi -->
<div class="mt-6">
    <?= $pager->links('default', 'tailwind') ?>
</div>

<?= $this->endSection() ?>