<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= esc($pageTitle ?? 'Admin Panel') ?> | <?= getenv('app.name') ?></title>
    <link rel="icon" type="image/png" href="<?= base_url('assets/favicon.ico') ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-gray-100 font-sans">

<div x-data="{ sidebarOpen: true }" class="flex h-screen bg-gray-200">
    <!-- Sidebar -->
    <?= $this->include('backend/layouts/_sidebar') ?>
    
    <div class="flex-1 flex flex-col overflow-hidden">
        <!-- Header -->
        <?= $this->include('backend/layouts/_header') ?>
        
        <!-- Konten Utama -->
        <main class="flex-1 overflow-x-hidden overflow-y-auto bg-gray-100">
            <div class="container mx-auto px-6 py-8">
                <!-- Judul Halaman -->
                <h3 class="text-gray-700 text-3xl font-medium"><?= esc($pageTitle ?? '') ?></h3>
                
                <!-- Notifikasi Flash -->
                <?= $this->include('backend/layouts/_notifications') ?>

                <!-- Konten Spesifik Halaman -->
                <?= $this->renderSection('main') ?>
            </div>
        </main>
    </div>
</div>

</body>
</html>